<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Preview\TrustedComms;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 */
abstract class BrandsInformationOptions {
    /**
     * @param string $ifNoneMatch Standard `If-None-Match` HTTP header
     * @return FetchBrandsInformationOptions Options builder
     */
    public static function fetch(string $ifNoneMatch = Values::NONE): FetchBrandsInformationOptions {
        return new FetchBrandsInformationOptions($ifNoneMatch);
    }
}

class FetchBrandsInformationOptions extends Options {
    /**
     * @param string $ifNoneMatch Standard `If-None-Match` HTTP header
     */
    public function __construct(string $ifNoneMatch = Values::NONE) {
        $this->options['ifNoneMatch'] = $ifNoneMatch;
    }

    /**
     * Standard `If-None-Match` HTTP header. For more information visit: https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/If-None-Match.
     *
     * @param string $ifNoneMatch Standard `If-None-Match` HTTP header
     * @return $this Fluent Builder
     */
    public function setIfNoneMatch(string $ifNoneMatch): self {
        $this->options['ifNoneMatch'] = $ifNoneMatch;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Preview.TrustedComms.FetchBrandsInformationOptions ' . $options . ']';
    }
}